% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_id.R
\name{guess_id}
\alias{guess_id}
\title{Guess gene id type}
\usage{
guess_id(gene, regulondb)
}
\arguments{
\item{gene}{Character vector of gene identifiers (id, name, bnumber or gi).}

\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}
}
\value{
A \code{character(1)} vector with the name column guessed value.
}
\description{
Given a gene identifier, return the most likely gene_id type.
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Lists all available identifiers for "araC"
## Guess name
guess_id("araC", e_coli_regulondb)

## Guess id
guess_id("ECK120000050", e_coli_regulondb)

## Guess bnumber
guess_id("b0064", e_coli_regulondb)
}
\author{
Jesús Emiliano Sotelo Fonseca
}
\keyword{bnumber,}
\keyword{geneid,}
\keyword{gi,}
\keyword{synonyms}
