% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summary.R
\name{get_regulatory_summary}
\alias{get_regulatory_summary}
\title{Return summary of gene regulation.}
\usage{
get_regulatory_summary(regulondb, gene_regulators)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{gene_regulators}{Result from \code{\link[=get_gene_regulators]{get_gene_regulators()}} or vector of
genes}
}
\value{
A data frame with the following columns:
\itemize{
\item The name or gene of TF
\item Regulated Genes per TF
\item Percent of regulated genes per TF
\item positive, negative or dual regulation
\item Name(s) of regulated genes
}
}
\description{
This function takes the output of \code{\link[=get_gene_regulators]{get_gene_regulators()}} with
format multirow,
onerow or table, or a vector with genes and retrieves information about the
TFs and their regulated genes
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Get the araC regulators
araC_regulation <-
    get_gene_regulators(
        e_coli_regulondb,
        genes = c("araC"),
        format = "multirow",
        output.type = "TF"
    )

## Summarize the araC regulation
get_regulatory_summary(e_coli_regulondb, araC_regulation)

## Retrieve summary of genes 'araC' and 'modB'
get_regulatory_summary(e_coli_regulondb,
    gene_regulators = c("araC", "modB")
)

## Obtain the summary for 'ECK120000050' and 'modB'
get_regulatory_summary(e_coli_regulondb,
    gene_regulators = c("ECK120000050", "modB")
)
}
\author{
Carmina Barberena Jonas, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chávez
}
\keyword{networks,}
\keyword{regulation}
\keyword{retrieval,}
\keyword{summary,}
