% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gene_synonyms.R
\name{get_gene_synonyms}
\alias{get_gene_synonyms}
\title{Retrieve gene synonyms}
\usage{
get_gene_synonyms(
  regulondb,
  genes,
  from = "name",
  to = c("id", "name", "bnumber", "gi")
)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{genes}{Character vector of gene identifiers (id, name, bnumber or gi).}

\item{from}{A \code{character()} specifying one of: id, name, bnumber of gi}

\item{to}{A \code{character()} specifying one or more of: id, name, bnumber of gi}
}
\value{
A \link[=regulondb_result-class]{regulondb_result} object.
}
\description{
Given a list of genes (id, name, bnumber or gi),
get the gene synonyms (name, bnumber of gi).
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Lists all available identifiers for "araC"
get_gene_synonyms(e_coli_regulondb, "araC", from = "name")

## Retrieve only the ID
get_gene_synonyms(e_coli_regulondb, "araC", from = "name", to = "id")

## Use an ID to retrieve the synonyms
get_gene_synonyms(e_coli_regulondb, "ECK120000998", from = "id")
}
\author{
Jesús Emiliano Sotelo Fonseca
}
\keyword{bnumber,}
\keyword{geneid,}
\keyword{gi,}
\keyword{synonyms}
