% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset.R
\name{get_dataset}
\alias{get_dataset}
\title{Extract data from RegulonDB}
\usage{
get_dataset(
  regulondb,
  dataset = NULL,
  attributes = NULL,
  filters = NULL,
  and = TRUE,
  interval = NULL,
  partialmatch = NULL,
  output_format = "regulondb_result"
)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{dataset}{Dataset of interest. Use the function list_datasets for an
overview of valid datasets.}

\item{attributes}{Vector of attributes to be retrieved.}

\item{filters}{List of filters to be used. The names should correspond to
the attribute and the values correspond to the condition for selection.}

\item{and}{Logical argument. If FALSE, filters will be considered under the
"OR" operator}

\item{interval}{the filters whose values will be considered as interval}

\item{partialmatch}{name of the condition(s) with a string pattern for full
or partial match in the query}

\item{output_format}{A string specifying the output format. Possible options
are "regulondb_result", "GRanges", "DNAStringSet" or "BStringSet".}
}
\value{
By default, a regulon_results object. If specified in the parameter
output_format, it can also return either a GRanges object or a Biostrings
object.
}
\description{
This function retrieves data from RegulonDB. Attributes from
datasets can be selected and filtered.
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Obtain all the information from the "GENE" dataset
get_dataset(e_coli_regulondb, dataset = "GENE")

## Get the attributes posright and name from the "GENE" dataset
get_dataset(e_coli_regulondb,
    dataset = "GENE",
    attributes = c("posright", "name")
)

## From "GENE" dataset, get the gene name, strand, posright, product name
## and id of all genes regulated with name like "ara", strand as "forward"
## with a position right between 2000 and 40000
get_dataset(
    e_coli_regulondb,
    dataset = "GENE",
    attributes = c("name", "strand", "posright", "product_name", "id"),
    filters = list(
        name = c("ara"),
        strand = c("forward"),
        posright = c("2000", "40000")
    ),
    and = TRUE,
    partialmatch = "name",
    interval = "posright"
)
}
\author{
Carmina Barberena Jonas, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chávez
}
