% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_database.R
\name{connect_database}
\alias{connect_database}
\title{Connect to the regulondb database}
\usage{
connect_database(
  ah = AnnotationHub::AnnotationHub(),
  bfc = BiocFileCache::BiocFileCache()
)
}
\arguments{
\item{ah}{An \code{AnnotationHub} object
\link[AnnotationHub:AnnotationHub-class]{AnnotationHub-class}. Can be \code{NULL}
if you want to force to use the backup download mechanism.}

\item{bfc}{A \code{BiocFileCache} object
\link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}. Used when
\code{ah} is not available.}
}
\value{
An \link[RSQLite:SQLiteConnection-class]{SQLiteConnection-class}
connection to the RegulonDB database.
}
\description{
This function downloads the RegulonDB SQLite database file
prior to making a connection to it. It will cache the database file such
that subsequent calls will run faster. This function requires an active
internet connection.
}
\examples{

## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Connect to the database without using AnnotationHub
regulondb_conn_noAH <- connect_database(ah = NULL)
}
