% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_condition.R
\name{build_condition}
\alias{build_condition}
\title{Construct logical condition to query database}
\usage{
build_condition(regulondb, dataset, filters, operator, interval, partialmatch)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{dataset}{dataset of interest}

\item{filters}{List of filters to be used. The names should correspond to
the attribute and the values correspond to the condition for selection.}

\item{operator}{A string indicating if all the filters (AND) or some of them
(OR) should be met}

\item{interval}{the filters with values considered as interval}

\item{partialmatch}{name of the condition(s) with a string pattern for full
or partial match in the query}
}
\value{
A \code{character(1)} with the sql logical condition to query the dataset
.
}
\description{
Given a list of filters, this function builds a logical
condition to query database.
The output is used in \code{\link[=get_dataset]{get_dataset()}}.
}
\examples{

## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## Build the condition for ara
build_condition(
    e_coli_regulondb,
    dataset = "GENE",
    filters = list(
        name = c("ara"),
        strand = c("forward"),
        posright = c("2000", "40000")
    ),
    operator = "AND",
    interval = "posright",
    partialmatch = "name"
)
}
\author{
Carmina Barberena Jonás, Jesús Emiliano Sotelo Fonseca,
José Alquicira Hernández, Joselyn Chávez
}
