% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCrosswiseDimRed.R
\name{plotCrosswiseDimRed}
\alias{plotCrosswiseDimRed}
\title{plotCrosswiseDimRed}
\usage{
plotCrosswiseDimRed(mPT, type = "PCA", GM_clust = NA, clust_met =
"hclust", nc = 5, listRS = NULL, main = "", labSize = 2, emphasize = FALSE,
labAll = FALSE, labMaxOverlap = 100, ellipse = TRUE, colPal = NULL,
perplexity = 10, theta = 0.1, return_table = FALSE, return_plot = TRUE, ...)
}
\arguments{
\item{mPT}{an object of class genoMatriXeR or a numerical matrix.}

\item{type}{character, dimensional reduction algorithm to use ("PCA", "tSNE", "UMAP"). (default  = "PCA")}

\item{GM_clust}{numeric, vector of assigned clusters used to cluster the matrix. If NA, the matrix will be clustered using the method defined by \code{clust_met}. (default = NA)}

\item{clust_met}{character, unsupervised cluster strategy used (\link{hclust}, \link{kmeans} or \link{pam}). (default = "hclust")}

\item{nc}{numeric, number of clusters to define if using the default "kmeans" method. (default = 5)}

\item{listRS}{list, a list of names of region sets of interest to be highlighted in the graph. (default = NULL)}

\item{main}{character, title for the plot. (default = "")}

\item{labSize}{numeric, size for point labels in the plot. If 0, no labels will be plotted. (default = 2)}

\item{emphasize}{logical, if TRUE, only the cluster in which the elements of \code{listRS} are present will be highlighted. (default = FALSE)}

\item{labAll}{logical, if TRUE all data points are labelled, even if not in \code{listRS} when \code{emphasize} = TRUE. (default = FALSE)}

\item{labMaxOverlap}{numeric, max.overlaps for \code{\link{geom_text_repel}}. (default = 100)}

\item{ellipse}{logical, if TRUE ellipses will be drawn around the clusters. (default = FALSE)}

\item{colPal}{character, colors to use as palette for the plot. If NULL, default colors will be used. (default = NULL)}

\item{perplexity, theta}{numeric, if \code{type} = "tSNE" values of perplexity and theta for the function \code{\link[=Rtsne]{Rtsne()}}. (default = 10)}

\item{return_table}{logical, if TRUE a table with the cluster assigned to each region is returned. (default = FALSE)}

\item{return_plot}{logical, if TRUE a plot is returned. (default = TRUE)}

\item{...}{further arguments to be passed on to other methods}
}
\value{
A ggplot object or a table with cluster assignments is returned.
}
\description{
Plot a visualization of a \link[=genoMatriXeR-class]{genoMatriXeR} object (or matrix) using different
dimensional reduction algorithms (PCA, tSNE and UMAP).
}
\details{
This function generates a plot with a two-dimensional representation of the
association data stored in a \link[=genoMatriXeR-class]{genoMatriXeR} object by
using either PCA, tSNE or UMAP transformations of the data. This function
incorporates a clustering step and allows to highlight specific region sets
of interest and the clusters they belong to. In addition to generating a plot,
a table with the cluster assignments can be retrieved.
}
\examples{

data("cw_Alien")

cw_Alien_ReG <- makeCrosswiseMatrix(cw_Alien_ReG)

plotCrosswiseDimRed(cw_Alien_ReG, type = "PCA")

CDR_clust <- plotCrosswiseDimRed(cw_Alien_ReG, type = "UMAP", return_table = TRUE)

print(CDR_clust)

}
\seealso{
\code{\link[=crosswisePermTest]{crosswisePermTest()}}
}
