% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitRegions.R
\name{splitRegions}
\alias{splitRegions}
\title{Split Regions}
\usage{
splitRegions(A, B, min.size=1, track.original=TRUE)
}
\arguments{
\item{A}{a region set in any of the formats accepted by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{B}{a region set in any of the formats accepted by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{min.size}{numeric value, minimal size of the new regions}

\item{track.original}{logical indicating if you want to keep the original regions and additional information in the output}
}
\value{
A GRanges with the splitted regions.
}
\description{
Splits a region set A by both ends of the regions in a second region set B.
}
\examples{
A <- data.frame(chr=1, start=c(1, 15, 24, 40, 50), end=c(10, 20, 30, 45, 55))

B <- data.frame(chr=1, start=c(2, 12, 28, 35), end=c(5, 25, 33, 43))

splits <- splitRegions(A, B)

plotRegions(list(A, B, splits), chromosome=1, regions.labels=c("A", "B", "splits"), regions.colors=3:1)

}
\seealso{
\code{\link{toDataframe}}, \code{\link{toGRanges}}, \code{\link{subtractRegions}}, \code{\link{commonRegions}}, \code{\link{extendRegions}}, \code{\link{joinRegions}}, \code{\link{mergeRegions}}, \code{\link{overlapRegions}}
}
