% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_region_map.R
\name{create_region_map}
\alias{create_region_map}
\title{Create a Region Map Between CpGs and Gene Regions}
\usage{
create_region_map(cpg_gr, genes_gr, verbose = FALSE)
}
\arguments{
\item{cpg_gr}{A \code{GRanges} object containing the genomic positions of CpG
sites.}

\item{genes_gr}{A \code{GRanges} object containing the genomic positions of gene
regions (e.g., promoters) of interest.}

\item{verbose}{Boolean; print output statements}
}
\value{
A \code{data.frame} with mappings between gene IDs and CpG IDs,
facilitating associating CpG sites with their corresponding gene regions for
downstream analyses.
}
\description{
This function generates a map that assigns CpG sites to gene regions,
establishing a linkage based on their genomic coordinates and providing
a foundation for subsequent region-specific analyses.
}
\examples{
library(GenomicRanges)

# Creating dummy GRanges objects for CpG sites and gene regions
cpg_gr <- GRanges(seqnames=c("chr1", "chr1", "chr2"),
                    ranges=IRanges(start=c(100, 200, 150),
                    end=c(100, 200, 150)))
genes_gr <- GRanges(seqnames=c("chr1", "chr2", "chr2"),
                    ranges=IRanges(start=c(50, 100, 130),
                    end=c(150, 180, 160)))
# Creating a region map using the function
region_map <- create_region_map(cpg_gr, genes_gr)
}
