% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_control_metrics.R
\name{bactrl}
\alias{bactrl}
\title{bactrl}
\usage{
bactrl(
  cdf = NULL,
  baset = "reduced",
  rg = NULL,
  rs = NULL,
  gs = NULL,
  baseline = 3000,
  biotin.baseline = 1
)
}
\arguments{
\item{cdf}{Control probe annotations (optional, NULL, data.frame, cols = properties, rows = probes).}

\item{baset}{Either the most informative BeadArray metrics (a.k.a. "reduced" set, 
5 metrics, recommended), or the full set of 17 metrics ("all").}

\item{rg}{An RGChannelSet object (optional, NULL).}

\item{rs}{Red signal data (optional, NULL, data.frame, columns are probes, rows are samples, 
column names are addresses, rownames are samples/GSM IDs).}

\item{gs}{Green signal data (optional, NULL, data.frame, columns are probes, rows are samples, 
column names are addresses, rownames are samples/GSM IDs).}

\item{baseline}{Baseline measure for signals (integer, 3000).}

\item{biotin.baseline}{Baseline to use for biotin controls (integer, 1).}
}
\value{
Matrix of BeadArray signal values
}
\description{
Get the BeadArray control metrics from HM450K platform red/grn signals.
}
\details{
This function calculates the BeadArray quality metrics based on Illumina's 
documentation and previous work (see references). Based on previous work, this function
can calculate the full set of 17 metrics (e.g. baset = 'all'), or the reduced set of
5 metrics (e.g. baset = 'reduced'), where the latter is recommended for most purposes. 
For additional details, consult the BeadArray metrics vignette in this package.
}
\examples{
dir <- system.file("extdata", "bactrl", package = "recountmethylation")
rgf <- get(load(file.path(dir, "rgf-cgctrl-test_hm450k-minfidata.rda")))
mba <- bactrl(rg = rgf)
}
\references{
1. S. K. Maden, et. al., "Human methylome variation across Infinium 450K data on the Gene 
Expression Omnibus," NAR Genomics and Bioinformatics, Volume 3, Issue 2, June 2021

2. Illumina, “Illumina Genome Studio Methylation Module v1.8,” Nov. 2010.

3. Illumina, “BeadArray Controls Reporter Software Guide,” Oct. 2015.

4. J. A. Heiss and A. C. Just, “Identifying mislabeled and contaminated DNA methylation 
microarray data: an extended quality control toolset with examples from GEO,” Clinical 
Epigenetics, vol. 10, June 2018.
'
}
\seealso{
bathresh
}
