% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rse_manual.R
\name{create_rse_manual}
\alias{create_rse_manual}
\title{Internal function for creating a recount3 RangedSummarizedExperiment object}
\usage{
create_rse_manual(
  project,
  project_home = project_homes(organism = organism, recount3_url = recount3_url),
  type = c("gene", "exon", "jxn"),
  organism = c("human", "mouse"),
  annotation = annotation_options(organism),
  bfc = recount3_cache(),
  jxn_format = c("ALL", "UNIQUE"),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3"),
  verbose = getOption("recount3_verbose", TRUE)
)
}
\arguments{
\item{project}{A \code{character(1)} with the ID for a given study.}

\item{project_home}{A \code{character(1)} with the home directory for the
\code{project}. You can find these using \code{project_homes()}.}

\item{type}{A \code{character(1)} specifying whether you want to access gene,
exon, or exon-exon junction counts.}

\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{annotation}{A \code{character(1)} specifying which annotation you want to
download. Only used when \code{type} is either \code{gene} or \code{exon}.}

\item{bfc}{A \link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}
object where the files will be cached to, typically created by
\code{recount3_cache()}.}

\item{jxn_format}{A \code{character(1)} specifying whether the exon-exon junction
files are derived from all the reads (\code{ALL}) or only the uniquely mapping
read counts (\code{UNIQUE}). Note that \code{UNIQUE} is only available for some
projects: GTEx and TCGA for human.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}

\item{verbose}{A \code{logical(1)} indicating whether to show messages with
updates.}
}
\value{
A
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object.
}
\description{
This function is used internally by \code{create_rse()} to construct a \code{recount3}
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object that contains the base-pair coverage counts at the \code{gene} or \code{exon}
feature level for a given annotation.
}
\examples{

## Unlike create_rse(), here we create an RSE object by
## fully specifying all the arguments for locating this study
rse_gene_SRP009615_manual <- create_rse_manual(
    "SRP009615",
    "data_sources/sra"
)
rse_gene_SRP009615_manual

## Check how much memory this RSE object uses
pryr::object_size(rse_gene_SRP009615_manual)

## Test with a collection that has a single sample
## NOTE: this requires loading the full data for this study when
## creating the RSE object
rse_gene_ERP110066_collection_manual <- create_rse_manual(
    "ERP110066",
    "collections/geuvadis_smartseq",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
)
rse_gene_ERP110066_collection_manual

## Check how much memory this RSE object uses
pryr::object_size(rse_gene_ERP110066_collection_manual)

## Mouse example
rse_gene_DRP002367_manual <- create_rse_manual(
    "DRP002367",
    "data_sources/sra",
    organism = "mouse"
)
rse_gene_DRP002367_manual

## Information about how this RSE was made
metadata(rse_gene_DRP002367_manual)

## Test with a collection that has one sample, at the exon level
## NOTE: this requires loading the full data for this study (nearly 6GB!)
\dontrun{
rse_exon_ERP110066_collection_manual <- create_rse_manual(
    "ERP110066",
    "collections/geuvadis_smartseq",
    type = "exon",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
)
rse_exon_ERP110066_collection_manual


## Check how much memory this RSE object uses
pryr::object_size(rse_exon_ERP110066_collection_manual)
# 409 MB

## Test with a collection that has one sample, at the junction level
## NOTE: this requires loading the full data for this study
system.time(rse_jxn_ERP110066_collection_manual <- create_rse_manual(
    "ERP110066",
    "collections/geuvadis_smartseq",
    type = "jxn",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
))
rse_jxn_ERP110066_collection_manual

## Check how much memory this RSE object uses
## NOTE: this doesn't run since 2 files are missing on the test site!
pryr::object_size(rse_jxn_ERP110066_collection_manual)
}

\dontrun{
## For testing and debugging
project <- "ERP110066"
project_home <- "collections/geuvadis_smartseq"

project <- "SRP009615"
project_home <- "data_sources/sra"
type <- "gene"
organism <- "human"
annotation <- "gencode_v26"
jxn_format <- "ALL"
bfc <- recount3_cache()
recount3_url <- "http://idies.jhu.edu/recount3/data"
verbose <- TRUE
}
}
\references{
\url{https://doi.org/10.12688/f1000research.12223.1} for details on the
base-pair coverage counts used in recount2 and recount3.
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url}()},
\code{\link{locate_url_ann}()},
\code{\link{project_homes}()},
\code{\link{read_counts}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
