% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getApproxCovar.R
\name{getApproxCovar}
\alias{getApproxCovar}
\title{Obtain a null covariance matrix of binned test statistics}
\usage{
getApproxCovar(statsPerm, ...)
}
\arguments{
\item{statsPerm}{The pxB matrix of permutation z-values in the columns}

\item{...}{passed on to binStats}
}
\value{
The covariance matrix of binned z-values
}
\description{
Obtain a null covariance matrix of binned test statistics
}
\note{
This is not the covariance matrix of the p test statistic, nor of the
   data! It is an approximate covariance matrix of binned test statistics for
   visualization and diagnostic purposes.
}
\examples{
p = 200; n = 50; B = 5e1
x = rep(c(0,1), each = n/2)
mat = cbind(
matrix(rnorm(n*p/10, mean = 5+x),n,p/10), #DA
matrix(rnorm(n*p*9/10, mean = 5),n,p*9/10) #Non DA
)
mat = mat = mat + rnorm(n, sd = 0.3) #Introduce some dependence
fdrRes = reconsi(mat, x, B = B)
corMat = getApproxCovar(fdrRes$statsPerm)
}
