% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openingDetails.R
\name{openingDetails}
\alias{openingDetails}
\title{Report opening details about the book}
\usage{
openingDetails(..., Copyright = NULL)
}
\arguments{
\item{...}{Further named strings to be included in the opening details.}

\item{Copyright}{String containing copyright information; defaults to \code{"Bioconductor, <current year>"}.}
}
\value{
A string containing the formatted details for inclusion into a YAML header.
}
\description{
Report opening details about the book, to be executed as an R expression in the \code{Date:} field.
}
\details{
It is usually sufficient to set something like
\preformatted{date: "`r rebook::openingDetails()`"
}
in the YAML header of the book, thereby ensuring that the book details are printed after the title but before any contents.
This assumes that none of the details have problematic characters, particularly double quotes.

Details are extracted from a \code{DESCRIPTION} file in the current or any parent directory.
This assumes that authors are formatted as \code{Authors@R} and the \code{License} and \code{Date} fields are specified.
}
\examples{
wd <- getwd()
setwd(system.file(package="rebook"))
cat(openingDetails(), '\n')
setwd(wd)
}
\author{
Aaron Lun
}
