% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileChapter.R
\name{compileChapter}
\alias{compileChapter}
\title{Compile a Rmarkdown file}
\usage{
compileChapter(path, cache = TRUE)
}
\arguments{
\item{path}{String containing a path to an Rmarkdown file.}

\item{cache}{Logical scalar indicating whether the compilation should be cached.}
}
\value{
The specified file is (re)compiled to generate the corresponding \code{*_cache} directories.
\code{NULL} is invisibly returned.
}
\description{
Compile a Rmarkdown file - typically a chapter of a book - 
so that \code{\link{extractCached}} calls work correctly in other chapters.
}
\details{
Compilation is performed in a completely fresh R session,
to ensure that objects, globals and loaded packages from one chapter do not affect the next chapter.

If an error is encountered during compilation of any Rmarkdown file,
the standard output of \code{\link{render}} leading up to the error is printed out before the function exists.
}
\examples{
tmp <- tempfile(fileext=".Rmd")
write(file=tmp, "```{r, echo=FALSE, results='asis'}
rebook::chapterPreamble()
```

```{r}
rodan <- 1
```")

compileChapter(tmp)

file.exists(sub(".Rmd$", ".html", tmp)) # output HTML exists.
file.exists(sub(".Rmd$", "_cache", tmp)) # output cache exists.
exists("rodan") # FALSE
}
\seealso{
\code{\link{extractCached}}, which calls this function.
}
\author{
Aaron Lun
}
