% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{readRaw}
\alias{readRaw}
\alias{rawDiag}
\title{Reads selected raw file trailer information for rawDiag plot functions}
\usage{
readRaw(
  rawfile,
  msgFUN = function(x) {
     message(x)
 }
)
}
\arguments{
\item{rawfile}{the name of the raw file containing the mass spectrometry data from the Thermo Fisher Scientific instrument.}

\item{msgFUN}{this function is used for logging information while composing
the resulting data.frame. It can also be used for shiny progress bar. The
default is using the \code{message}.}
}
\value{
a \code{data.frame} containing the selected trailer information.
}
\description{
implements a wrapper function using the rawrr methods
\code{\link[rawrr]{readIndex}}, \code{\link[rawrr]{readTrailer}},
and \code{\link[rawrr]{readChromatogram}} to read
proprietary mass spectrometer generated data using third-party libraries.
}
\note{
The set up procedure for the rawrr package needs to be run in order to use
this package.
}
\examples{
rawDiag::checkRawrr()
rawrr::sampleFilePath() |>
  rawDiag::readRaw()
}
\references{
\doi{10.1021/acs.jproteome.8b00173}
}
\author{
Christian Panse (2016-2023)
}
