% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{buildRawDiagShinyApp}
\alias{buildRawDiagShinyApp}
\title{Build the rawDiag shiny application}
\usage{
buildRawDiagShinyApp(rawDir = (dirname(rawrr::sampleFilePath())))
}
\arguments{
\item{rawDir}{A directory containing the input raw files,
default is set to the \code{$HOME/Downloads} directory.}
}
\value{
returns the rawDiag shiny apps
}
\description{
Build the rawDiag shiny application
}
\note{
launch the shiny application by embracing your command line while
expecting the raw file in \code{$HOME/Downloads}
\itemize{
\item MacOSX and Linux: \verb{R -q -e "library(rawDiag); buildRawDiagShinyApp() |> shiny::runApp(launch.browser = TRUE)"}
\item Microsoft Windows: \verb{R.exe -e "library(rawDiag); buildRawDiagShinyApp() |> shiny::runApp(launch.browser = TRUE)"}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rawrr::sampleFilePath() |>
  dirname() |>
  rawDiag::buildRawDiagShinyApp() |>
  shiny::runApp()
  
 # or use your 'Download' folder
 (Sys.getenv('HOME') |>
   file.path("Downloads")) |>
   rawDiag::buildRawDiagShinyApp() |>
   shiny::runApp()
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
