% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{X_decomp}
\alias{X_decomp}
\title{Decomposition of the design matrix for random rotation generation}
\usage{
X_decomp(X = NULL, coef.d = seq_len(ncol(X) - 1))
}
\arguments{
\item{X}{Design matrix as generated by
\code{\link[stats:model.matrix]{model.matrix}}.}

\item{coef.d}{Non-\code{H0} coefficients.}
}
\value{
A \code{\link[base:list]{list}} object containing matrices \code{Xd},
  \code{Xhe} and rank of the qr decomposition.
}
\description{
Full QR decomposition of the design matrix \code{X}. No argument checks are
performed, see \code{Details}.
}
\details{
The design matrix \code{X} is QR decomposed into \code{X = Xq Xr}.
By performing a full QR decomposition, \code{Xq} is automatically extended to
a full basis. \code{Xq} is further split into \code{Xd} and \code{Xhe}, where
\code{Xd} corresponds to columns \code{coef.d} (non-\code{H0} or
non-Null-Hypothesis columns) and \code{Xhe} correspond to all other columns
(\code{H0} and error columns), see \code{\link[randRotation:initRandrot]{initRandrot}}.
No argument checks are performed for reasons
of performance as this function is called frequently by
\code{\link[randRotation:initRandrot]{initRandrot}} when weights are used.
See \insertCite{Hettegger2021}{randRotation} and \insertCite{Langsrud2005}{randRotation} for further details.
}
\examples{
design <- cbind(1, rep(0:1, 5))
X_decomp(design)
}
\references{
\insertAllCited{}
}
\author{
Peter Hettegger
}
