% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_editing.R
\name{make_de_object}
\alias{make_de_object}
\title{Make summarized experiment object for differential editing analysis}
\usage{
make_de_object(
  rse,
  edit_from = "A",
  edit_to = "G",
  min_prop = 0,
  max_prop = 1,
  min_samples = 1
)
}
\arguments{
\item{rse}{A \link{RangedSummarizedExperiment} object}

\item{edit_from}{This should correspond to a nucleotide or assay
(\code{A}, \code{C}, \code{G}, \code{T}, \code{Ref}, or \code{Alt}) you expect in the reference.
Ex. for A to I editing events, this would be \code{A}.}

\item{edit_to}{This should correspond to a nucleotide or assay
(\code{A}, \code{C}, \code{G}, \code{T}, \code{Ref}, or \code{Alt}) you expect in the editing site.
Ex. for A to I editing events, this would be \code{G}.}

\item{min_prop}{The minimum required proportion of reads edited at a site. At
least \code{min_samples} need to pass this to keep the site.}

\item{max_prop}{The maximum allowable proportion of reads edited at a site.
At least \code{min_samples} need to pass this to keep the site.}

\item{min_samples}{The minimum number of samples passing the \code{min_prop} and
\code{max_prop} cutoffs to keep a site.}
}
\value{
\link{RangedSummarizedExperiment} for use with \code{edgeR} or
\code{DESeq2}. Contains a \code{counts} assay with a matrix formatted
with 2 columns per sample (ref and alt counts).
}
\description{
Generates a \link{RangedSummarizedExperiment} object for use with
\code{edgeR} or \code{DESeq2} . Will generate a \code{counts} assay with
a matrix formatted with 2 columns per sample,
representing the reference and editing allele counts.
}
\examples{
library(SummarizedExperiment)
rse_adar_ifn <- mock_rse()
rse <- calc_edit_frequency(rse_adar_ifn)
dse <- make_de_object(rse, min_samples = 1)
assay(dse, "counts")[1:5, ]
dse
}
