% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_rse.R
\name{filter_splice_variants}
\alias{filter_splice_variants}
\title{Filter out sites near splice sites}
\usage{
filter_splice_variants(rse, txdb, splice_site_dist = 4, ignore.strand = FALSE)
}
\arguments{
\item{rse}{\code{SummarizedExperiment::SummarizedExperiment} with editing sites}

\item{txdb}{\code{GenomicFeatures::TxDb}}

\item{splice_site_dist}{distance to splice site}

\item{ignore.strand}{if \code{TRUE}, ignore strand when comparing editing sites to
splice sites}
}
\value{
\code{SummarizedExperiment::SummarizedExperiment} with sites
adjacent to splice sites removed.
}
\description{
Remove editing sites found in regions proximal to annotated
splice junctions.
}
\examples{
if(require("txdbmaker")) {
  rse_adar_ifn <- mock_rse()

  # mock up a txdb with genes
  gr <- GRanges(c(
      "DHFR:310-330:-",
      "DHFR:410-415:-",
      "SSR3:100-155:-",
      "SSR3:180-190:-"
  ))
  gr$source <- "raer"
  gr$type <- "exon"
  gr$source <- NA
  gr$phase <- NA_integer_
  gr$gene_id <- c(1, 1, 2, 2)
  gr$transcript_id <- rep(c("1.1", "2.1"), each = 2)
  txdb <- txdbmaker::makeTxDbFromGRanges(gr)

  filter_splice_variants(rse_adar_ifn, txdb)
}


}
\seealso{
Other se-filters: 
\code{\link{filter_clustered_variants}()},
\code{\link{filter_multiallelic}()}
}
\concept{se-filters}
