% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_rse.R
\name{filter_multiallelic}
\alias{filter_multiallelic}
\title{Filter out multi-allelic sites}
\usage{
filter_multiallelic(se)
}
\arguments{
\item{se}{\code{SummarizedExperiment::SummarizedExperiment}}
}
\value{
\code{SummarizedExperiment::SummarizedExperiment} with multiallelic sites
removed.  A new column,\code{ALT} will be added to \code{rowData()} indicating the
single allele present at the site.
}
\description{
Remove sites with multiple variant bases from a
\code{SummarizedExperiment}. \code{rowData()} gains a new column, \code{ALT}, that
contains the variant allele detected at each site.
}
\examples{
rse_adar_ifn <- mock_rse()
filter_multiallelic(rse_adar_ifn)

}
\seealso{
Other se-filters: 
\code{\link{filter_clustered_variants}()},
\code{\link{filter_splice_variants}()}
}
\concept{se-filters}
