% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annot_rse.R
\name{annot_from_gr}
\alias{annot_from_gr}
\title{Annotate sites using GRanges object}
\usage{
annot_from_gr(obj, gr, cols_to_map, RLE = TRUE, sep = ",", ...)
}
\arguments{
\item{obj}{RangedSummarizedExperiment or GRanges object}

\item{gr}{GRanges with annotations to map to obj}

\item{cols_to_map}{character vector of columns from GRanges to map to
SummarizedExperiment.
If the vector has names, the names will be the column names in the output.}

\item{RLE}{If TRUE, columns added will returned as \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle()}} vectors
to reduce memory}

\item{sep}{separator string, defaults to comma.}

\item{...}{additional arguments to pass to \code{\link[GenomicRanges:findOverlaps-methods]{GenomicRanges::findOverlaps()}}}
}
\value{
Either a SummarizedExperiment or GRanges object with additional
annotations provided by the supplied GRanges object.
}
\description{
Utility function to map annotations from GRanges to rowData of
SummarizedExperiment or to mcols of GRanges object. If multiple features
overlap then they will be concatenated with the specified separtor string.
}
\examples{
library(SummarizedExperiment)
rse_adar_ifn <- mock_rse()
gr <- GRanges(rep(c("SSR3", "SPCS3"), c(5, 15)),
    IRanges(seq(1, 500, by = 25), width = 50),
    strand = "+"
)

gr$feature <- sample(1:100, size = 20)
gr$id <- sample(LETTERS, size = 20)

rse <- annot_from_gr(rse_adar_ifn, gr, c(feature_set = "feature", "id"))
rowData(rse)

}
