% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scudoCytoscape.R
\name{scudoCytoscape}
\alias{scudoCytoscape}
\title{Create a Cytoscape network from the output of scudoNetwork}
\usage{
scudoCytoscape(graph, title = "Scudo Graph", collection = "SCUDO")
}
\arguments{
\item{graph}{object of class \code{\link[igraph:aaa-igraph-package]{igraph}},
like the result of \code{\link{scudoNetwork}}}

\item{title}{the title of the network}

\item{collection}{the name of the Cytoscape collection}
}
\value{
The network SUID (an integer).
}
\description{
A wrapper to \code{\link[RCy3]{RCy3}} function calls to plot the result of
\code{\link{scudoNetwork}} in Cytoscape 3. Cytoscape must be open before
running this function.
}
\examples{
# generate dummy dataset
exprData <- data.frame(a = 11:20, b = 16:25,
    c = rev(1:10), d = c(1:2, rev(3:10)))
rownames(exprData) <- letters[11:20]
grps <- as.factor(c("G1", "G1", "G2", "G2"))
nTop <- 2
nBottom <- 3

# run scudoTrain and scudoNetwork
res <- scudoTrain(exprData, grps, nTop, nBottom, foldChange = FALSE,
    featureSel = FALSE)
col <- c("#FF00FF", "#FF00FF", "#00FF00", "#00FF00")
net <- scudoNetwork(res, N = 0.5, colors = col)

# run scudoCytoscape (with Cytoscape open)
\dontrun{scudoCytoscape(res, title = "scudoCytoscape output")}

}
\seealso{
\code{\link{scudoNetwork}}, \code{\link[RCy3]{RCy3}}
}
\author{
Matteo Ciciani \email{matteo.ciciani@gmail.com}, Thomas Cantore
\email{cantorethomas@gmail.com}
}
