% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_vlines}
\alias{track_vlines}
\title{Overlay vertical lines from a bed file}
\usage{
track_vlines(file)
}
\arguments{
\item{file}{String. The location of the track file}
}
\value{
genome_track
}
\description{
\code{track_vlines()} overlay vertical lines over the whole plot. The only parameter to be passed is a bed file.
}
\examples{
tads_dir <- system.file("extdata", "tad_classification.bed",
  package = "rGenomeTracks"
)
genes_dir <- system.file("extdata", "dm3_genes.bed.gz",
  package = "rGenomeTracks"
)
links_dir <- system.file("extdata", "test.arcs",
  package = "rGenomeTracks"
)
tads <- track_domains(tads_dir, color = "#cccccc", border_color = "red")
links_overlay <- track_links(links_dir,
  color = "red",
  line_width = 3, links_type = "loop",
  overlay_previous = "share-y"
)
links <- track_links(links_dir,
  color = "blue",
  line_width = 3, height = 3
)
genes <- track_bed(genes_dir,
  height = 7, style = "flybase",
  fontsize = 10
)
vlines <- track_vlines(genes_dir)
\dontrun{
plot_gtracks(tads + links_overlay + links + genes + vlines, chr = "X", start = 30 * 10^5, end = 35 * 10^5)
}
}
\author{
Omar Elashkar
}
