% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_track.R
\name{+,genome_track,genome_track-method}
\alias{+,genome_track,genome_track-method}
\title{Adding genome_track Objects}
\usage{
\S4method{+}{genome_track,genome_track}(e1, e2)
}
\arguments{
\item{e1}{genome_track object.}

\item{e2}{genome_track object.}
}
\value{
genome_track object
}
\description{
This method adds two "genome_track" objects together.
}
\examples{
tads_dir <- system.file("extdata", "tad_classification.bed",
  package = "rGenomeTracks"
)
genes_dir <- system.file("extdata", "dm3_genes.bed.gz",
  package = "rGenomeTracks"
)
links_dir <- system.file("extdata", "test.arcs",
  package = "rGenomeTracks"
)
tads <- track_domains(tads_dir, color = "#cccccc", border_color = "red")
links_overlay <- track_links(links_dir,
  color = "red",
  line_width = 3, links_type = "loop",
  overlay_previous = "share-y"
)
links <- track_links(links_dir,
  color = "blue",
  line_width = 3, height = 3
)
genes <- track_bed(genes_dir,
  height = 7, style = "flybase",
  fontsize = 10
)
vlines <- track_vlines(genes_dir)
\dontrun{
plot_gtracks(tads + links_overlay + links + genes + vlines, chr = "X", start = 30 * 10^5, end = 35 * 10^5)
}
}
\author{
Omar Elashkar
}
