% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyBiopax.R
\name{addControl}
\alias{addControl}
\title{This function adds a new control to the biopax model.}
\usage{
addControl(
  biopax,
  CONTROL_TYPE = c("ACTIVATION", "INHIBITION"),
  CONTROLLER = "",
  CONTROLLED = c(),
  id = NULL
)
}
\arguments{
\item{biopax}{A biopax model}

\item{CONTROL_TYPE}{string. Specifies wether this is an activating or inhibiting control.}

\item{CONTROLLER}{string. ID of the physicalEntityParticipant instance that is the controller of this interaction.}

\item{CONTROLLED}{vector of strings. IDs of the interaction and/or pathway instances that are being controlled.}

\item{id}{string. ID for the control. If NULL a new ID is generated with prefix "control".}
}
\value{
Returns the biopax model with the added pathway.
}
\description{
This function adds a new interaction of class control to the biopax model. This is a convenience function to add controls,
internally the function addBiopaxInstance is called with properties CONTROL-TYPE, CONTROLLER and CONTROLLED set.
}
\examples{
biopax = createBiopax(level=2)
biopax = addPhysicalEntity(biopax, class="protein", id="p_id1", NAME="protein1")
biopax = addPhysicalEntityParticipant(biopax, "p_id1", id="PEP_p_id1")
biopax = addPhysicalEntity(biopax, class="protein", id="p_id2", NAME="protein2")
biopax = addPhysicalEntityParticipant(biopax, "p_id2", id="PEP_p_id2")
biopax = addBiochemicalReaction(biopax, LEFT=c("PEP_p_id1"), RIGHT=c("PEP_p_id2"), id="biochem_id_1")
biopax = addPhysicalEntity(biopax, class="protein", id="p_id3", NAME="controllerProtein1")
biopax = addPhysicalEntityParticipant(biopax, "p_id3", id="PEP_p_id3")
biopax = addControl(biopax, CONTROL_TYPE="ACTIVATION", CONTROLLER="PEP_p_id3", CONTROLLED="biochem_id_1", id="c_id1")
biopax$dt
}
\author{
fkramer
}
