% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{matdensity}
\alias{matdensity}
\title{Density plots of columns in a matrix}
\usage{
matdensity(
  object,
  groupFactor = NULL,
  type = "l",
  lty = 1,
  brewer.n = 8,
  brewer.name = "Dark2",
  ...
)
}
\arguments{
\item{object}{object an object which is inherited from an 
\code{eSet} such as an \code{ExpressionSet} or 
\code{MethylSet} object. The \code{object} can also be a 
data frame or matrix with observations
(e.g. probes or genes) on the rows and samples as the 
columns.}

\item{groupFactor}{an optional factor variable representing which 
group each column in \code{object} belongs to. It is important 
that values in \code{groupFactor} be in the same 
order as the columns in \code{object}.}

\item{type}{the type of lines to plot. Default type is line ("l").}

\item{lty}{the line type. Default is the solid line.}

\item{brewer.n}{the number of colors in the palette from the RColorBrewer 
package. Default is 8.}

\item{brewer.name}{the name of the palette from the RColorBrewer package. 
Default is "Dark2".}

\item{...}{other arguments that can be passed to the 
code{matplot} function.}
}
\value{
A density plot for each column in \code{object}
}
\description{
Plots the density of the columns of a matrix
}
\examples{
library(minfi)
data(flowSorted)
p <- getBeta(flowSorted, offset = 100)
pd <- pData(flowSorted)
matdensity(object = p, groupFactor = pd$CellType, xlab = "beta values",
ylab = "density")
}
