% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSamples.R
\name{compareSamples}
\alias{compareSamples}
\title{Sample comparison}
\usage{
compareSamples(
  x,
  i,
  group,
  class1,
  class2,
  covariates = NULL,
  confint = TRUE,
  number = nrow(x),
  adjust.method = "BH",
  sort.by = "B",
  resort.by = NULL,
  p.value = 1,
  fc = NULL,
  lfc = NULL,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{SummarizedExperiment} object.}

\item{i}{A string or integer value specifying which assay values to use. The
assay is expected to contain log-transformed intensities.}

\item{group}{A string specifying the name of variable containing a class
label of each sample in \code{colData(x)}.}

\item{class1, class2}{A string specifying the class label of samples to be
compared. Must be one of \code{group} levels. No need to be specified if
\code{group} has only two levels. This function evaluates the contrast:
\code{class2 - class1}.}

\item{covariates}{A vector indicating the names of variables to be included
in the model as covariates. The covariates must be found in \code{colData(x)}.}

\item{confint}{A logical specifying whether 95\% confidence intervals of
log-fold-change need to be reported. Alternatively, a numeric value
between zero and one specifying the confidence level required.}

\item{number}{The maximum number of metabolic features to list.}

\item{adjust.method}{A string specifying which p-value adjustment method to
use. Options, in increasing conservatism, include "none", "BH", "BY" and
"holm". See \link{p.adjust} for the complete list of options. A NULL value will
result in the default adjustment method, which is "BH".}

\item{sort.by}{A string specifying which statistic to rank the metabolic
features by. Possible values for topTable are "logFC", "AveExpr", "t",
"P", "p", "B" or "none" (Permitted synonyms are "M" for "logFC", "A" or
"Amean" for "AveExpr", "T" for "t" and "p" for "P").}

\item{resort.by}{A string specifying statistic to sort the selected
metabolic features by in the output. Possibilities are the same as for
sort.by.}

\item{p.value}{A numeric value specifying a cut-off for adjusted p-values.
Only metabolic features with lower p-values are listed.}

\item{fc}{A numeric value specifying a minimum fold-change to be required.
If specified, the function output only includes metabolic features with
absolute fold-change greater than \code{fc}.}

\item{lfc}{A numeric value specifying a minimum log-fold-change required.
\code{fc} and \code{lfc} are alternative ways to specify a fold-change cut-off and,
if both are specified, then \code{fc} take precedence.}

\item{...}{Additional arguments passed to \link[limma:ebayes]{limma::eBayes}.}
}
\value{
A data.frame with a row for the metabolic features and the following
columns:
\itemize{
\item logFC: an estimate of log-fold-change corresponding to the contrast tested
\item CI.L: a left limit of confidence interval for \code{logFC} (if \code{confint} is
enabled)
\item CI.R: a right limit of confidence interval for \code{logFC} (if \code{confint} is
enabled)
\item AveExpr: an average log-expression/abundance of metabolic features
\item t: a moderated t-statistic
\item P.Value: a raw p-value
\item adj.P.Value: an adjusted p-value
\item B: a log-odds that the metabolic feature is differentially expressed
}
}
\description{
Function to make a comparisons between two groups in study samples with a
\linkS4class{SummarizedExperiment}.
}
\details{
This function provides a simplified interface of fitting a linear model to
make a comparison of interest using the \link[limma:lmFit]{limma::lmFit}, \link[limma:ebayes]{limma::eBayes}, and
\link[limma:toptable]{limma::topTable} functions. For more flexible model specifications (e.g.,
interaction model, multi-level model), please use a standard workflow
outlined in the \code{limma} package user's guide.
}
\examples{

data(faahko_se)

compareSamples(faahko_se, i = "knn_vsn", group = "sample_group", number = 5)

}
\references{
Ritchie ME, Phipson B, Wu D, Hu Y, Law CW, Shi W, Smyth GK. limma powers
differential expression analyses for RNA-sequencing and microarray studies.
Nucleic Acids Res. 2015 Apr 20;43(7):e47. doi: 10.1093/nar/gkv007. Epub 2015
Jan 20. PMID: 25605792; PMCID: PMC4402510.
}
\seealso{
See \link[limma:lmFit]{limma::lmFit}, \link[limma:ebayes]{limma::eBayes}, and \link[limma:toptable]{limma::topTable} for underlying
functions that do work.
}
