% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetMethods.R
\name{rmPeakList}
\alias{rmPeakList}
\title{remove the peakList of an ptrSet object}
\usage{
rmPeakList(object)
}
\arguments{
\item{object}{ptrSet object}
}
\value{
a ptrSet
}
\description{
This function is useful when you want to change the parameters of the detect 
peak function. First delete the peakList with \code{rmPeakList}, and apply 
\code{detectPeak}with the new parameters.
}
\examples{
library(ptairData)
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
exhaledPtrset <-rmPeakList(exhaledPtrset )
}
