% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{prepareAnnotationFromEvents}
\alias{prepareAnnotationFromEvents}
\title{Prepare annotation from alternative splicing events}
\usage{
prepareAnnotationFromEvents(...)
}
\arguments{
\item{...}{Data frame(s) of alternative splicing events to include in the
annotation}
}
\value{
List of data frames with the annotation from different data frames
joined by event type
}
\description{
In case more than one data frame with alternative splicing events is given,
the events are cross-referenced according to the chromosome, strand and
relevant coordinates per event type (see details).
}
\details{
Events from two or more data frames are cross-referenced based on
each event's chromosome, strand and specific coordinates relevant for each
event type:
\itemize{
     \item Skipped exon: constitutive exon 1 end, alternative exon (start
     and end) and constitutive exon 2 start
     \item Mutually exclusive exon: constitutive exon 1 end, alternative exon
     1 and 2 (start and end) and constitutive exon 2 start
     \item Alternative 5' splice site: constitutive exon 1 end, alternative
     exon 1 end and constitutive exon 2 start
     \item Alternative first exon: same as alternative 5' splice site
     \item Alternative 3' splice site: constitutive exon 1 end, alternative
     exon 1 start and constitutive exon 2 start
     \item Alternative last exon: same as alternative 3' splice site
}
}
\note{
When cross-referencing events, gene information is discarded.
}
\examples{
# Load sample files (SUPPA annotation)
folder <- "extdata/eventsAnnotSample/suppa_output/suppaEvents"
suppaOutput <- system.file(folder, package="psichomics")

# Parse and prepare SUPPA annotation
suppa <- parseSuppaAnnotation(suppaOutput)
annot <- prepareAnnotationFromEvents(suppa)

# Load sample files (rMATS annotation)
folder <- "extdata/eventsAnnotSample/mats_output/ASEvents/"
matsOutput <- system.file(folder, package="psichomics")

# Parse rMATS annotation and prepare combined annotation from rMATS and SUPPA
mats <- parseMatsAnnotation(matsOutput)
annot <- prepareAnnotationFromEvents(suppa, mats)
}
\seealso{
Other functions to prepare alternative splicing annotations: 
\code{\link{parseSuppaAnnotation}()}
}
\concept{functions to prepare alternative splicing annotations}
