% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalAccess.R
\name{getHighlightedPoints}
\alias{getHighlightedPoints}
\alias{setHighlightedPoints}
\alias{getZoom}
\alias{setZoom}
\alias{getSelectedPoints}
\alias{setSelectedPoints}
\alias{getLabelledPoints}
\alias{setLabelledPoints}
\title{Get or set points or regions for plots}
\usage{
getHighlightedPoints(id, category = getCategory())

setHighlightedPoints(id, events, category = getCategory())

getZoom(id, category = getCategory())

setZoom(id, zoom, category = getCategory())

getSelectedPoints(id, category = getCategory())

setSelectedPoints(id, events, category = getCategory())

getLabelledPoints(id, category = getCategory())

setLabelledPoints(id, events, category = getCategory())
}
\arguments{
\item{id}{Character: identifier}

\item{category}{Character: data category}

\item{events}{Integer: index of events}

\item{zoom}{Integer: range of X and Y coordinates for zooming}
}
\value{
Getters return globally accessible data, whereas setters return
\code{NULL} as they are only used to modify the Shiny session's state
}
\description{
Get or set points or regions for plots
}
\note{
Needs to be called inside a reactive function
}
\seealso{
Other functions to get and set global variables: 
\code{\link{getClinicalMatchFrom}()},
\code{\link{getDifferentialExpression}()},
\code{\link{getDifferentialSplicing}()},
\code{\link{getGlobal}()},
\code{\link{getGroups}()},
\code{\link{getSelectedDataPanel}()}
}
\concept{functions to get and set global variables}
\keyword{internal}
