% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalisation_functions.R
\name{plot_normalised_antigen}
\alias{plot_normalised_antigen}
\title{Comparison of normalised data by feature}
\usage{
plot_normalised_antigen(exprs_normalised_df, method, batch_correct)
}
\arguments{
\item{exprs_normalised_df}{a normalised data frame}

\item{method}{the method of normalisation used}

\item{batch_correct}{the batch correction}
}
\value{
A ggplot of various normalisation approaches
}
\description{
Comparison of normalised data by feature
}
\examples{
matrix_antigen <- readr::read_csv(system.file("extdata", 
"matrix_antigen.csv", package="protGear"))
normlise_vsn <- matrix_normalise(as.matrix(matrix_antigen),
method = "vsn",
return_plot = FALSE
)
plot_normalised_antigen(normlise_vsn,method="vsn",batch_correct=FALSE)
}
