% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{getUMAP}
\alias{getUMAP}
\title{getUMAP}
\usage{
getUMAP(projection, axis = 2, umapMethod = "naive", umapConfig = umap.defaults)
}
\arguments{
\item{projection}{martrix, a projection generated from projectR}

\item{axis}{integer, either 1 umap of projection or 2 for umap of transpose of projection}

\item{umapMethod}{character, implementation. Available methods are 'naive' (an implementation written in pure R) and 'umap-learn' (requires python package 'umap-learn')}

\item{umapConfig}{umap.config, a list of parameters to customize umap embedding}
}
\value{
A umap of projection
}
\description{
Function to provide umap of projection
}
\examples{
library(umap)
projection <- projectR(data=p.ESepiGen4c1l$mRNA.Seq,loadings=AP.RNAseq6l3c3t$Amean,
dataNames = map.ESepiGen4c1l[["GeneSymbols"]], full = TRUE)
umapConfig = umap.defaults
umapConfig$n_neighbors = 3
projectionUMAP <- getUMAP(projection,umapConfig = umapConfig)
}
