% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlateR.R
\name{correlateR}
\alias{correlateR}
\title{correlateR}
\usage{
correlateR(genes, dat, threshtype = "R", threshold = 0.7, absR = FALSE, ...)
}
\arguments{
\item{genes}{gene or character vector of genes for reference expression pattern}

\item{dat}{matrix or data frame with  genes to be used for to calculate correlation}

\item{threshtype}{Default "R" indicates thresholding by R value or equivalent. Alternatively, "N" indicates a numerical cut off.}

\item{threshold}{numeric indicating value at which to make threshold.}

\item{absR}{logical indicating where to include both positive and negatively correlated genes}

\item{...}{addtion inputs to cor, such as method}
}
\value{
A correlation matrix
}
\description{
Function to extract genes highly correlated with a gene or reference expression pattern.
}
\details{
If threshtype is "R" than threshold must be between -1 and 1. Otherwise if top N correlated genes are required, set \code{threshtype}
 as "N" and set \code{threshold} = N, i.e, the number of correlated genes required.
}
\examples{
cor2T<-correlateR(genes="T", dat=p.RNAseq6l3c3t, threshtype="N", threshold=10, absR=TRUE)

}
