% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-proActiv.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Visualizes heatmap of features for samples}
\usage{
plotHeatmap(
  result,
  by = "absolutePromoterActivity",
  features = NULL,
  cex.legend = 0.75,
  cex.row = NULL,
  cex.col = NULL,
  row.margin = 5,
  col.margin = 12,
  col = NULL,
  breaks = NULL,
  palette = "bluered"
)
}
\arguments{
\item{result}{A SummarizedExperiment object return by proActiv, with assays 
giving promoter counts and activity with gene expression stored as 
metadata. rowData contains promoter metadata and absolute promoter 
activity summarized across conditions. Condition must be provided.}

\item{by}{A character vector. The assay to visualize the heatmap for. 
One of promoterCounts, normalizedPromoterCounts, 
absolutePromoterActivity and geneExpression (unambiguous substrings can be 
supplied). Defaults to absolutePromoterActivity.}

\item{features}{Features to visualize. Either a list of promoterIds or 
geneIds. The features must correspond to the assay is used, i.e., if 
promoter assays are used, features must be promoterIds, while if gene
expression assay is used, features must be geneIds. Defaults to NULL 
(visualizes all features of the assay).}

\item{cex.legend}{A numeric value. Legend size.}

\item{cex.row}{A numeric value. Row label size.}

\item{cex.col}{A numeric value. Column label size.}

\item{row.margin}{A numeric value. Row margins.}

\item{col.margin}{A numeric value. Column margins.}

\item{col}{A vector of colours. Length should correspond to number of 
experimental conditions. Defaults to NULL.}

\item{breaks}{A numeric vector. Breaks for heatmap plotting.}

\item{palette}{A character vector. One of bluered, redblue, redgreen, 
greenred. Defaults to bluered.}
}
\value{
Displays heatmap.
}
\description{
Visualizes heatmap of features for samples
}
\examples{
files <- list.files(system.file('extdata/vignette/junctions', 
                       package = 'proActiv'), 
                       full.names = TRUE, pattern = 'replicate5')
promoterAnnotation <- promoterAnnotation.gencode.v34.subset
result <- proActiv(files = files,
                       promoterAnnotation  = promoterAnnotation,
                       condition = rep(c('A549', 'HepG2'), each=1),
                       fileLabels = NULL,
                       ncores = 1)
result <- result[complete.cases(assays(result)[[1]]),] 
plotHeatmap(result)

}
