% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkcomb.R
\docType{class}
\name{DRTraceSet-class}
\alias{DRTraceSet-class}
\alias{plot,DRTraceSet,missing-method}
\alias{DRTraceSet}
\title{DRTraceSet class manages dose-response information for a single cell line, multiple drugs}
\usage{
\S4method{plot}{DRTraceSet,missing}(x, y, ...)

DRTraceSet(
  cell_lines = c("SK-ES-1", "TC-71", "MHH-ES-1", "HCC-56", "SK-HEP-1"),
  drug = "Irinotecan",
  dataset = "CCLE"
)
}
\arguments{
\item{x}{for plot: instance of DRTraceSet}

\item{y}{for plot: not used}

\item{\dots}{not used}

\item{cell_lines}{character vector of cell line names, must be found 
in `cell_lines_v1` data of pogos package}

\item{drug}{character(1) drug name in `compounds_v1`}

\item{dataset}{character(1) dataset known to pharmacodb.pmgenomics.ca}
}
\value{
instance of DRTraceSet
}
\description{
DRTraceSet class manages dose-response information for a single cell line, multiple drugs

DRTraceSet constructor for multiple cell lines, single drug, single dataset
}
\note{
Will query pharmacodb for relevant dose-response information
}
\examples{
val = try(DRTraceSet())
if (!inherits(val, "try-error")) val
# otherwise pharmacodb.pmgenomics.ca is down
}
