% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{emb2knn}
\alias{emb2knn}
\title{Computes k nearest neighbors from embedding}
\usage{
emb2knn(x, k, BNPARAM = NULL)
}
\arguments{
\item{x}{A numeric matrix (with features as columns and items as
rows) from which nearest neighbors will be computed.}

\item{k}{The number of nearest neighbors.}

\item{BNPARAM}{A BiocNeighbors parameter object to compute kNNs. Ignored
unless the input is a matrix or data.frame. If omitted, the Annoy
approximation will be used if there are more than 500 elements.}
}
\value{
A knn list.
}
\description{
Computes k nearest neighbors from embedding.
}
\examples{
d1 <- mockData()
emb2knn(as.matrix(d1[,seq_len(2)]),k=5)
}
