% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-bed.R
\name{read_bed}
\alias{read_bed}
\alias{read_bed_graph}
\alias{read_narrowpeaks}
\title{Read a BED or BEDGraph file}
\usage{
read_bed(file, col_names = NULL, genome_info = NULL, overlap_ranges = NULL)

read_bed_graph(
  file,
  col_names = NULL,
  genome_info = NULL,
  overlap_ranges = NULL
)

read_narrowpeaks(
  file,
  col_names = NULL,
  genome_info = NULL,
  overlap_ranges = NULL
)
}
\arguments{
\item{file}{A path to a file or a connection.}

\item{col_names}{An optional character vector for including additional
columns in \code{file} that are not part of the BED/narrowPeaks specification.}

\item{genome_info}{An optional character string or a Ranges object
that contains information about the genome build. For example the USSC identifier
"hg19" will add build information to the returned GRanges.}

\item{overlap_ranges}{An optional Ranges object. Only the intervals in the file
that overlap the Ranges will be returned.}
}
\value{
A GRanges object
}
\description{
This is a lightweight wrapper to the import family
of functions defined in \pkg{rtracklayer}.

Read common interval based formats as GRanges.
}
\details{
This is a lightweight wrapper to the import family
of functions defined in \pkg{rtracklayer}.
The \code{read_narrowpeaks} function parses the ENCODE narrowPeak BED format (see
\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format12} for details.). As
such the parser expects four additional columns called (corresponding to
the narrowPeaks spec):
\itemize{
\item signalValue
\item pValue
\item qValue
\item peak
}
}
\examples{
test_path <- system.file("tests", package = "rtracklayer")
bed_file <- file.path(test_path, "test.bed")
gr <- read_bed(bed_file)
gr
gr <- read_bed(bed_file, genome_info = "hg19")
gr
olap <-  as_granges(data.frame(seqnames = "chr7", start = 1, end = 127473000))
gr <- read_bed(bed_file,
              overlap_ranges = olap)
# bedGraph
bg_file <- file.path(test_path, "test.bedGraph")
gr <- read_bed_graph(bg_file)
gr
# narrowpeaks
np_file <- system.file("extdata", "demo.narrowPeak.gz",  package="rtracklayer")
gr <- read_narrowpeaks(np_file, genome_info = "hg19")
gr
}
\seealso{
\code{rtracklayer::\link[rtracklayer:BEDFile-class]{BEDFile()}}
}
