% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace-anchors.R
\name{replace_anchors}
\alias{replace_anchors}
\alias{replace_anchors,GInteractions,character,GenomicRanges-method}
\alias{replace_anchors,GInteractions,numeric,GenomicRanges-method}
\alias{replace_anchors,PinnedGInteractions,missing,GenomicRanges-method}
\alias{replace_anchors,AnchoredPinnedGInteractions,missing,GRanges-method}
\alias{replace_anchors,AnchoredPinnedGInteractions,numeric,GRanges-method}
\title{Replace anchors of a GInteractions}
\usage{
replace_anchors(x, id, value)

\S4method{replace_anchors}{GInteractions,character,GenomicRanges}(x, id, value)

\S4method{replace_anchors}{GInteractions,numeric,GenomicRanges}(x, id, value)

\S4method{replace_anchors}{PinnedGInteractions,missing,GenomicRanges}(x, id, value)

\S4method{replace_anchors}{AnchoredPinnedGInteractions,missing,GRanges}(x, id, value)

\S4method{replace_anchors}{AnchoredPinnedGInteractions,numeric,GRanges}(x, id, value)
}
\arguments{
\item{x}{a (Pinned)GInteractions object}

\item{id}{Which anchors to replace ("first" or "second"). Ignored if
the GInteractions is already pinned to a specific set of anchors.}

\item{value}{A GRanges object vector the same length as x.}
}
\value{
a (Pinned)GInteractions object.
}
\description{
Replace anchors of a GInteractions
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30
chr1 11 20 chr1 51 55
chr1 11 30 chr1 51 55
chr1 11 30 chr2 51 60",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(type = c('cis', 'cis', 'cis', 'trans'), score = runif(4))

####################################################################
# 1. Replace anchors of a GInteractions object
####################################################################

gi |> replace_anchors(2, value = anchors1(gi))

gi |> replace_anchors(1, value = anchors2(gi))

gi |> replace_anchors(1, value = GenomicRanges::GRanges(c(
  "chr1:1-2", "chr1:2-3", "chr1:3-4", "chr1:4-5"
)))

####################################################################
# 2. Replace anchors of a pinned GInteractions object
####################################################################

gi |> pin_by(1) |> replace_anchors(value = anchors1(gi))

gi |> replace_anchors(1, value = anchors2(gi))

gi |> 
  pin_by(1) |> 
  replace_anchors(value = GenomicRanges::GRanges(c(
    "chr1:1-2", "chr1:2-3", "chr1:3-4", "chr1:4-5"
  ))) |> 
  pin_by(2) |> 
  replace_anchors(value = GenomicRanges::GRanges(c(
    "chr2:1-2", "chr2:2-3", "chr2:3-4", "chr2:4-5"
  ))) 

}
