% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor.R
\name{ginteractions-anchor}
\alias{ginteractions-anchor}
\alias{anchor.AnchoredPinnedGInteractions}
\alias{unanchor.AnchoredPinnedGInteractions}
\alias{anchor_start.PinnedGInteractions}
\alias{anchor_end.PinnedGInteractions}
\alias{anchor_center.PinnedGInteractions}
\alias{anchor_3p.PinnedGInteractions}
\alias{anchor_5p.PinnedGInteractions}
\alias{anchor_start.AnchoredPinnedGInteractions}
\alias{anchor_end.AnchoredPinnedGInteractions}
\alias{anchor_center.AnchoredPinnedGInteractions}
\alias{anchor_3p.AnchoredPinnedGInteractions}
\alias{anchor_5p.AnchoredPinnedGInteractions}
\title{Manage GInteractions anchors with plyranges}
\usage{
\method{anchor}{AnchoredPinnedGInteractions}(x)

\method{unanchor}{AnchoredPinnedGInteractions}(x)

\method{anchor_start}{PinnedGInteractions}(x)

\method{anchor_end}{PinnedGInteractions}(x)

\method{anchor_center}{PinnedGInteractions}(x)

\method{anchor_3p}{PinnedGInteractions}(x)

\method{anchor_5p}{PinnedGInteractions}(x)

\method{anchor_start}{AnchoredPinnedGInteractions}(x)

\method{anchor_end}{AnchoredPinnedGInteractions}(x)

\method{anchor_center}{AnchoredPinnedGInteractions}(x)

\method{anchor_3p}{AnchoredPinnedGInteractions}(x)

\method{anchor_5p}{AnchoredPinnedGInteractions}(x)
}
\arguments{
\item{x}{A PinnedGInteractions object}
}
\value{
\itemize{
\item \verb{anchor_*} functions return an AnchoredPinnedGInteractions object.
\item \code{anchor} returns a character string indicating where the pinned
anchors are anchored at.
\item \code{unanchor} removes the anchoring for a AnchoredPinnedGInteractions object.
}
}
\description{
Manage GInteractions anchors with plyranges
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30 + +
chr1 11 20 chr1 51 55 + +
chr1 11 30 chr1 51 55 - -
chr1 11 30 chr2 51 60 - -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "strand1", "strand2")
) |> 
  as_ginteractions() |> 
  mutate(score = runif(4), type = c('cis', 'cis', 'cis', 'trans'))

gi

####################################################################
# 1. Anchoring pinned genomic interactions with plyranges
####################################################################

gi |> pin_by("second") |> anchor_end()

gi |> pin_by("first") |> anchor_start()

gi |> 
  pin_by("first") |> anchor_center() |> stretch(4) |> 
  pin_by("second") |> anchor_3p() |> stretch(-2)
}
