% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pairdist.R
\name{add_pairdist}
\alias{add_pairdist}
\title{Appends distance between interaction anchors}
\usage{
add_pairdist(x, type = "mid", colname = "pairdist")
}
\arguments{
\item{x}{The query GInteractions}

\item{type}{A character string specifying the type of distance to compute. Can take values of "mid", "gap", "span", "diag" or "intra".}

\item{colname}{name of column to hold pair distance values}
}
\value{
The GInteractions with an additional column containing the
distance between each pair of anchors.
}
\description{
Appends distance between interaction anchors, using
\code{InteractionSet::pairdist}
}
\examples{
gi <- read.table(text = "
chr1 100 200 chr1 5000 5100 bedpe_example1 30 + -
chr1 1000 5000 chr2 3000 3800 bedpe_example2 100 + -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "name", "score", "strand1", "strand2")
) |> as_ginteractions()

add_pairdist(gi)
}
