% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCool.R
\name{readCool}
\alias{readCool}
\title{Read a .(m)cool file and return Hi-C data as a dataframe}
\usage{
readCool(
    file,
    chrom,
    chromstart = NULL,
    chromend = NULL,
    altchrom = NULL,
    altchromstart = NULL,
    altchromend = NULL,
    resolution = "auto",
    zrange = NULL,
    norm = "NONE",
    binChunkSize = 5e6,
    params = NULL,
    quiet = FALSE
)
}
\arguments{
\item{file}{A character value specifying the path to the .(m)cool file.}

\item{chrom}{Chromosome of data, as a string.}

\item{chromstart}{Integer start position on chromosome.}

\item{chromend}{Integer end position on chromosome.}

\item{altchrom}{Alternate chromosome for interchromosomal data,
as a string.}

\item{altchromstart}{Alternate chromosome integer start position
for interchromosomal data.}

\item{altchromend}{Alternate chromosome integer end position
for interchromosomal data.}

\item{resolution}{A numeric specifying the width of each pixel.
"auto" will attempt to choose a resolution in basepairs based on
the size of the region.}

\item{zrange}{A numeric vector of length 2 specifying the range of
interaction scores, where extreme values will be set to the max or min.}

\item{norm}{Character value specifying hic data normalization method.
This value must be found in the .(m)cool file.
Default value is \code{norm = "NONE"}.}

\item{binChunkSize}{A numeric specifying the number of bin indices to read 
from a file for a given region at a given resolution. If the total amount of 
data is larger than the \code{binChunkSize}, data will be read in multiple
chunks. Default value is \code{binChunkSize = 5e6}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{quiet}{A logical indicating whether or not to print messages.}
}
\value{
Returns a 3-column dataframe in sparse upper triangular
format with the following columns: \code{chrom}, \code{altchrom},
\code{counts}.
}
\description{
Read a .(m)cool file and return Hi-C data as a dataframe
}
\examples{

## .cool file
coolFile <- file.path(tempdir(), "Rao2014-IMR90-MboI-allreps-filtered.1000kb.cool")
download.file(url = "https://usgs2.osn.mghpcc.org/cooler01/examples/hg19/Rao2014-IMR90-MboI-allreps-filtered.1000kb.cool",
    destfile = coolFile, mode = "wb")

## Read in region `chr2:10000000-22000000` at 1000Kb cool file resolution
coolData <- readCool(file = coolFile, chrom = "chr2", chromstart = 10000000,
                     chromend = 22000000,
                     resolution = 1000000)

## .mcool file
mcoolFile <- file.path(tempdir(), "LEUK_HEK_PJA27_inter_30.mcool")
download.file(url = "https://zenodo.org/records/10906240/files/LEUK_HEK_PJA27_inter_30.mcool?download=1",
    destfile = mcoolFile, mode = "wb")

## Read in region `chr2:1000000-5000000` at 100Kb resolution
mcoolData_100Kb <- readCool(file = mcoolFile, chrom = "2",
                            chromstart = 1000000, chromend = 5000000,
                            resolution = 100000)

## Read in data for chr2 at 2500Kb resolution 
mcoolData_2500Kb <- readCool(file = mcoolFile, chrom = "2",
                             resolution = 2500000)
}
\seealso{
\link[plotgardener]{readHic}
}
\author{
Sarah Parker, Nicole Kramer
}
