% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotText.R
\name{plotText}
\alias{plotText}
\title{Plot text within a plotgardener layout}
\usage{
plotText(
    label,
    fontcolor = "black",
    fontsize = 12,
    rot = 0,
    check.overlap = FALSE,
    x,
    y,
    just = "center",
    default.units = "inches",
    params = NULL,
    ...
)
}
\arguments{
\item{label}{Character or expression of text to be plotted.}

\item{fontcolor}{A character value specifying text fontcolor.
Default value is \code{fontcolor = "black"}.}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 12}.}

\item{rot}{A numeric specifying the angle to rotate the text.
Default value is \code{rot = 0}.}

\item{check.overlap}{A logical value to indicate whether to check
for and omit overlapping text.
Default value is \code{check.overlap = FALSE}.}

\item{x}{A numeric vector or unit object specifying text x-location.}

\item{y}{A numeric vector, unit object, or a character vector of
values containing a "b" combined with a numeric value
specifying text y-locations.
The character vector will place text y-locations relative to the
bottom of the most recently plotted plot according to the
units of the plotgardener page.}

\item{just}{Justification of text relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = "center"}.}

\item{default.units}{A string indicating the default units to use if
\code{x} or \code{y} are only given as numerics or numeric vectors.
Default value is \code{default.units = "inches"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{text} object containing relevant
placement and \link[grid]{grob} information.
}
\description{
Plot text within a plotgardener layout
}
\examples{
## Create a page
pageCreate(width = 4, height = 2, default.units = "inches")

## Plot text, adjusting fontsize and fontface
plotText(
    label = "plotgardener", fontsize = 14, fontface = "bold",
    x = 1, y = 1, just = "center", default.units = "inches"
)

## Plot text, adjusting color, rotation, and fontfamily
plotText(
    label = "coordinate-based", fontcolor = "#225EA8", rot = 90,
    fontfamily = "HersheyScript", x = 2, y = 1, just = "center",
    default.units = "inches"
)

## Plot a text label in multiple places at once
plotText(
    label = "R", x = c(0.5, 1, 1.5), y = 1.5, just = "center",
    default.units = "inches"
)

## Plot a vector of text labels
plotText(
    label = c("pg", "plot", "gardener"), x = 3, y = c(0.5, 1, 1.75),
    just = "center", default.units = "inches"
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[grid]{grid.text}
}
