% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampler.R
\name{model_w}
\alias{model_w}
\title{Estimate the marginal likelihood that mutations in buffy coat
and cfDNA reflect CH or correspond to germline mutations.
If germline, the allele frequency should be 50 percent.
The prior should be diffuse enough to handle CHIP mutations which are
potentially way less than 50 percent}
\usage{
model_w(dat, params)
}
\arguments{
\item{dat}{tibble containing vectors yand n. y and n should be named}

\item{params}{a list with named elements that must include the following
a which is the prior expectation for number of CH or germline variants
observed in the sequencing data
b which is the prior expectation for number of fragments
reflecting CH or germline}
}
\value{
list of samples, probability densities, and likelihood for non-tumor
assumption
}
\description{
Estimate the marginal likelihood that mutations in buffy coat
and cfDNA reflect CH or correspond to germline mutations.
If germline, the allele frequency should be 50 percent.
The prior should be diffuse enough to handle CHIP mutations which are
potentially way less than 50 percent
}
\examples{
param.list <- list(ctc=list(a=1, b=9999),
                   ctdna=list(a=1, b=9),
                   chip=list(a=1, b=9),
                   montecarlo.samples=50e3,
                   prior.weight=0.1)
dat <- data.frame(y=c(4, 1),
              n=c(1000, 1000),
              analyte=c("plasma", "buffy coat"),
              mutation="mutA",
              sample_id="id1")
model_w(dat, param.list)
}
