% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plaid.R
\name{replaid.scse}
\alias{replaid.scse}
\title{Fast calculation of scSE score}
\usage{
replaid.scse(
  X,
  matG,
  removeLog2 = NULL,
  scoreMean = FALSE,
  assay = "logcounts",
  min.genes = 5,
  max.genes = 500
)
}
\arguments{
\item{X}{Gene or protein expression matrix. Generally log
transformed. See details. Genes on rows, samples on columns.
Also accepts SummarizedExperiment or SingleCellExperiment objects.}

\item{matG}{Gene sets sparse matrix. Genes on rows, gene sets on
columns. Also accepts BiocSet objects or GMT lists.}

\item{removeLog2}{Logical for whether to remove the Log2, i.e. will
apply power transform (base2) on input (default TRUE).}

\item{scoreMean}{Logical for whether computing sum or mean as score
(default FALSE).}

\item{assay}{Character: assay name for Bioconductor objects. Default "logcounts".}

\item{min.genes}{Integer: minimum genes per gene set. Default 5.}

\item{max.genes}{Integer: maximum genes per gene set. Default 500.}
}
\value{
Matrix of single-sample scSE enrichment scores.
Gene sets on rows, samples on columns.
}
\description{
Calculates Single-Cell Signature Explorer (Pont et
al., 2019) scores using plaid back-end. The computation is
10-100x faster than the original code.
}
\details{
Computing the scSE requires running plaid on the linear
(not logarithmic) score and perform additional normalization by
the total UMI per sample. We have wrapped this in a single
convenience function:

To replicate the original "sum-of-UMI" scSE score, set \code{removeLog2=TRUE}
and \code{scoreMean=FALSE}. scSE and plaid scores become more similar for
\code{removeLog2=FALSE} and \code{scoreMean=TRUE}.

We have extensively compared the results from \code{replaid.scse} and
from the original scSE (implemented in GO lang) and we showed
almost identical results in the score, logFC and p-values.
}
\examples{
# Create example expression matrix (log-transformed)
set.seed(123)
X <- log2(matrix(rpois(500, lambda = 10) + 1, nrow = 50, ncol = 10))
rownames(X) <- paste0("GENE", 1:50)
colnames(X) <- paste0("Sample", 1:10)

# Create example gene sets
gmt <- list(
  "Pathway1" = paste0("GENE", 1:15),
  "Pathway2" = paste0("GENE", 10:25)
)
matG <- gmt2mat(gmt)

# Compute scSE scores (original method)
scores <- replaid.scse(X, matG, removeLog2 = TRUE, scoreMean = FALSE)
print(scores[1:2, 1:5])

# Compute scSE scores (mean method)
scores_mean <- replaid.scse(X, matG, removeLog2 = TRUE, scoreMean = TRUE)
print(scores_mean[1:2, 1:5])

}
