% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{gset.rankcor}
\alias{gset.rankcor}
\title{Calculate gene set rank correlation}
\usage{
gset.rankcor(rnk, gset, compute.p = FALSE, use.rank = TRUE)
}
\arguments{
\item{rnk}{Numeric vector or matrix of gene ranks, with genes as row names}

\item{gset}{Numeric matrix of gene sets, with genes as row/column names}

\item{compute.p}{Logical indicating whether to compute p-values}

\item{use.rank}{Logical indicating whether to rank transform rnk before correlation}
}
\value{
Named list with components:
\itemize{
\item rho - Matrix of correlation coefficients between rnk and gset
\item p.value - Matrix of p-values for correlation (if compute.p = TRUE)
\item q.value - Matrix of FDR adjusted p-values (if compute.p = TRUE)
}
}
\description{
Compute rank correlation between a gene rank vector/matrix and gene sets
}
\details{
This function calculates sparse rank correlation between rnk and each
column of gset using \code{qlcMatrix::corSparse()}. It handles missing values in
rnk by computing column-wise correlations.

P-values are computed from statistical distribution
}
\examples{
# Create example rank vector
set.seed(123)
ranks <- rnorm(100)
names(ranks) <- paste0("GENE", 1:100)

# Create example gene sets as sparse matrix
gmt <- list(
  "Pathway1" = paste0("GENE", 1:20),
  "Pathway2" = paste0("GENE", 15:35),
  "Pathway3" = paste0("GENE", 30:50)
)
genesets <- gmt2mat(gmt)

# Calculate rank correlation
result <- gset.rankcor(ranks, genesets, compute.p = TRUE)
print(result$rho)
print(result$p.value)

}
