% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalHeatmap.R
\name{evalHeatmap}
\alias{evalHeatmap}
\title{evalHeatmap}
\usage{
evalHeatmap(
  res,
  step = NULL,
  what,
  what2 = NULL,
  agg.by = NULL,
  agg.fn = mean,
  filterExpr = NULL,
  scale = "colCenterScale",
  value_format = "\%.2f",
  reorder_rows = FALSE,
  show_heatmap_legend = FALSE,
  show_column_names = FALSE,
  col = NULL,
  font_factor = 0.9,
  row_split = NULL,
  shortNames = TRUE,
  value_cols = c("black", "white"),
  title = NULL,
  name = NULL,
  anno_legend = TRUE,
  ...
)
}
\arguments{
\item{res}{Aggregated pipeline results (i.e. the output of `runPipeline` or
`aggregateResults`)}

\item{step}{Name of the step for which to plot the evaluation results. If 
unspecified, will use the latest step that has evaluation results.}

\item{what}{What metric to plot.}

\item{what2}{If the step has more than one benchmark data.frame, which one
to use. The function will attempt to guess that automatically based on 
`what`, and will notify in case of ambiguity.}

\item{agg.by}{Aggregate results by these columns (default no aggregation)}

\item{agg.fn}{Function for aggregation (default mean)}

\item{filterExpr}{An optional filtering expression based on the columns of 
the target dataframe, (e.g. `filterExpr=param1=="value1"`).}

\item{scale}{Controls the scaling of the columns for the color mapping. Can 
either be a logical (TRUE will use NA-safe column z-scores, FALSE will not 
scale) or a function performing the scaling. The default uses the
 `colCenterScale` function (per-column centering, but per-matrix variance
 scaling).}

\item{value_format}{Format for displaying cells' values (use 
`value_format=""` to disable)}

\item{reorder_rows}{Logical; whether to sort rows (default FALSE). The row 
names themselves can also be passed to specify an order, or a 
`ComplexHeatmap`.}

\item{show_heatmap_legend}{Passed to `Heatmap` (default FALSE)}

\item{show_column_names}{Passed to `Heatmap` (default FALSE)}

\item{col}{Colors for the heatmap, or a color-mapping function as produced by
`colorRamp2`. If passing a vector of colors and the data is scaled, there 
should be an odd number of colors. By default, will apply linear mapping (if
the data is not scaled) or signed sqrt mapping (if scaled) on the 
`viridisLite::inferno` palette.}

\item{font_factor}{A scaling factor applied to fontsizes (default 1)}

\item{row_split}{Optional column (included in `agg.by`) by which to split
the rows. Alternatively, an expression using the columns (retained after
aggregation) can be passed.}

\item{shortNames}{Logical; whether to use short row names (with only
the parameter values instead of the parameter name and value pairs), default
TRUE.}

\item{value_cols}{A vector of length 2 indicating the colors of the values
(above and below the mean), if printed}

\item{title}{Plot title}

\item{name}{Heatmap name (e.g. used for the legend)}

\item{anno_legend}{Logical; whether to plot the legend for the datasets}

\item{...}{Passed to `Heatmap`}
}
\value{
A Heatmap
}
\description{
General heatmap representation of aggregated evaluation results. By default,
the actual metric values are printed in the cells, and while the coloring is
determined by \code{\link{colCenterScale}} (number of matrix-median absolute
 deviations from the column means). Unless the total number of analyses is
 small, it is strongly recommended to use the `agg.by` argument to limit the
 size and improve the readability of the heatmap.
}
\examples{
data("exampleResults", package="pipeComp")
evalHeatmap( exampleResults, step="clustering", what=c("ARI","MI","min_pr"), 
             agg.by=c("filt", "norm"), row_split = "norm" ) +
evalHeatmap( exampleResults, step="clustering", what="ARI", 
             agg.by=c("filt", "norm"), filterExpr=n_clus==true.nbClusts, 
             name="ARI at true k", title="ARI at
true K" )
}
