% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAheatmap.R
\name{GSAheatmap}
\alias{GSAheatmap}
\title{Heatmap of top significant gene sets}
\usage{
GSAheatmap(
  gsaRes,
  cutoff = 5,
  adjusted = FALSE,
  ncharLabel = 25,
  cellnote = "pvalue",
  columnnames = "full",
  colorkey = TRUE,
  colorgrad = NULL,
  cex = NULL
)
}
\arguments{
\item{gsaRes}{an object of class \code{GSAres}, as returned from
\code{runGSA()}.}

\item{cutoff}{an integer n, so that the top n gene sets (plus possible ties)
in each directionality class will be included in the heatmap.}

\item{adjusted}{a logical, whether to use adjusted p-values or not. Note
that if \code{runGSA} was run with the argument \code{adjMethod="none"}, the
adjusted p-values will be equal to the original p-values.}

\item{ncharLabel}{the number of characters to include in the row labels.}

\item{cellnote}{a character string selecting the information to be printed
inside each cell of the heatmap. Either \code{"pvalue"}, \code{"rank"},
\code{"nGenes"} or \code{"none"}. Note that the actual heatmap will always
be based on the gene set ranks.}

\item{columnnames}{either \code{"full"} (default) or \code{"abbr"} to use
full or abbreviated column labels. Will save some space for the heatmap if
set to \code{"abbr"}}

\item{colorkey}{a logical (default \code{TRUE}), whether or not to display
the colorkey. Will save some space for the heatmap if turned off.}

\item{colorgrad}{a character vector giving the color names to use in the
heatmap.}

\item{cex}{a numeric, to control the text size.}
}
\value{
A list, returned invisibly, containing the matrix of p-values
(adjusted or non-adjusted depending on the settings) as represented in the
heatmap as well as the matrix of corresponding ranks and the matrix of
number of genes in each gene set (inlcuding the subset of up and down
regulated genes for the mixed directional classes).
}
\description{
This function selects the top scoring (most significant) gene sets for each
directionality class and produces a heatmap plot of the results.
}
\details{
This function selects the top significant gene sets in each directionality
class and draws a heatmap of the results. It provides a quick summary
alternative to the \code{\link{GSAsummaryTable}} function or the
\code{\link{networkPlot}}.
}
\examples{


   # Load example input data to GSA:
   data("gsa_input")
   
   # Load gene set collection:
   gsc <- loadGSC(gsa_input$gsc)
      
   # Run gene set analysis:
   gsares <- runGSA(geneLevelStats=gsa_input$pvals , directions=gsa_input$directions, 
                    gsc=gsc, nPerm=500)
                    
   # Make heatmap:
   dev.new(width=10,height=10)
   GSAheatmap(gsares)

}
\seealso{
\pkg{\link{piano}}, \code{\link{runGSA}},
\code{\link{GSAsummaryTable}}, \code{\link{networkPlot2}}, \code{\link{exploreGSAres}}
}
\author{
Leif Varemo \email{piano.rpkg@gmail.com} and Intawat Nookaew
\email{piano.rpkg@gmail.com}
}
