% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{updateCountsMeta}
\alias{updateCountsMeta}
\title{Update meta-data for counts collections}
\usage{
updateCountsMeta(
  counts_dir = getPhantasusConf("cache_folders")$rnaseq_counts,
  force = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{counts_dir}{path to counts cache directory}

\item{force}{logical value wich lets function replace existing \code{meta.rda} file}

\item{verbose}{logical value which determines a content of  the output.}
}
\description{
Creates \code{meta.rda} file which contain information about all samples in all collections.
Also function checks \code{priority.txt} file. This file is used to manage collections with the same samples.
}
\details{
First of all function checks validity of \code{priority.txt} file. \bold{Every} Collection should have \bold{unique} priority.
If \code{priority.txt} is not valid function creates new one, setting priorities for each subdirectory(=collection) equal to order in \code{list.dir} output.

Function updates \code{meta.rda} if this file is older than at least one \code{.h5} file in counts files.
\code{meta.rda} is \code{data.table} which is a result of union \code{data.table}s produced by \code{\link{getCountsMetaPart}} for each collection
}
\seealso{
{\code{\link{validateCountsCollection}},\code{\link{updateCountsMeta}}}
}
\keyword{internal}
