% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadPreloaded.R
\name{generatePreloadedSession}
\alias{generatePreloadedSession}
\title{Generate files for preloaded session from a session link.}
\usage{
generatePreloadedSession(sessionURL, preloadedName, preloadedDir)
}
\arguments{
\item{sessionURL}{String with session link produced by phantasus.}

\item{preloadedName}{String with name that should be assigned to the session.}

\item{preloadedDir}{Path to the directory with preloaded datasets and sessions.}
}
\value{
Function produces two files (\code{preloadedName.rda} with ExpressionSet
        and \code{preloadedName.json} with session features) in \code{preloadedDir} folder.
}
\description{
Generate files for preloaded session from a session link.
}
\examples{
\dontrun{
sessionURL <- "https://ctlab.itmo.ru/phantasus/?session=x063c1b365b9211" # link from 'Get dataset link...' tool in phantasus
newName <- "my_session" # user defined name
preloadedDir <- "./preloaded" # directory where files will be stored. In order too get access through phantasus web-app should be preloadedDir
dir.create(preloadedDir, showWarnings = FALSE)
generatePreloadedSession(sessionURL= sessionURL,
                         preloadedName = newName,
                         preloadedDir = preloadedDir)

servePhantasus(preloadedDir=preloadedDir, openInBrowser=FALSE)
# open browser manually at http://0.0.0.0:8000/phantasus/index.html?preloaded=my_session
}
}
