% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRegionsHelper.R
\name{crOverlapWithSummits}
\alias{crOverlapWithSummits}
\title{Overlap genomic regions with original summits to remove false positive}
\usage{
crOverlapWithSummits(data, input, removeFlankOverlaps = TRUE)
}
\arguments{
\item{data}{PeakCombiner data frame structure with required columns
named \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}. Additional
columns will be dropped}

\item{input}{The original input file from \code{combineRegions} to extract center
information}

\item{removeFlankOverlaps}{TRUE (default) / FALSE. If TRUE, the combined
regions are checked for an overlap with an input
summit. Regions without such an overlap are
considered as false positive regions caused by an
artificial overlap of neighboring regions due to
the expansion step. If FLASE, this step will be
skipped.}
}
\value{
A tibble with the following columns: \code{chrom}, \code{start}, \code{end},
\code{width}, \code{strand}, \code{name}.
}
\description{
Helper function for main function \link{combineRegions}.
Requires in memory data frame in the standard accepted format for the
peakCombiner package.
For details see the details for \link{combineRegions}.
}
\details{
Overlapping genomic regions must contain at least one 'center' from its
input sample regions to be considered a valid genomic region. Regions without
overlap might be a consequence of the expansion parameter and are likely to
be false positive.
}
